#!/usr/bin/perl -w

use warnings;
use strict;

use File::Spec;
my $dirname;

BEGIN {
    $dirname = (File::Spec->splitpath($0))[1];
    unshift @INC, "$dirname/../perl-lib";
}

use Mpfq::engine::conf qw(read_api);
use Mpfq::engine::utils qw(hfile_protect_begin hfile_protect_end);

my $api_file = "$dirname/../api.pl";
my @api_extensions = (':all');
my $noshift=0;
my $general_prefix='mpfq';

MAIN: {
	my $name = 'K';
	while (defined($_ = shift @ARGV)) {
		if (/api_file=(.*)$/) { $api_file=$1; next; }
		if (/name=(\w+)$/) { $name=$1; next; }
		if (/general_prefix=(\w+)$/) { $general_prefix=$1; next; }
		if (/--noshift$/) { $noshift=1; next; }
		if (/api_extensions?\+=(\w+)$/) { push @api_extensions, $1; next; }
		if (/api_extensions?=(\w+)$/) { @api_extensions=split(',',$1); next; }
		last;
	}

	my $api = Mpfq::engine::conf::read_api $api_file, @api_extensions;

	my $h = *STDOUT{IO};

	hfile_protect_begin $h, "mpfq_name_$name";

	print <<EOF;
/* Automatically generated file.
 *
 * This header file is just wrap-up code for accessing a global finite
 * field with convenient aliases.
 *
 * Note that this file is automatically generated from the mpfq api, and
 * is therefore guaranteed to contain all the api functions usable in the
 * current api_extensions.
 */

#ifndef MPFQ_LAST_GENERATED_TAG
#error "Please include an mpfq-generated header first"
#endif

/* cpp has its infelicities. Yes the extra step is needed */
#ifndef MPFQ_CONCAT4
#define MPFQ_CONCAT4(X,Y,Z,T) X ## Y ## Z ## T
#endif

#ifndef MPFQ_CREATE_FUNCTION_NAME
#define MPFQ_CREATE_FUNCTION_NAME(TAG,NAME) MPFQ_CONCAT4(${general_prefix}_,TAG,_,NAME)
#endif

#define ${name}common_name_(X) MPFQ_CREATE_FUNCTION_NAME(MPFQ_LAST_GENERATED_TAG,X)

EOF
	
	for my $f (@{$api->{'types'}}) {
		do { print "\n"; next; } if $f eq '/';
		print "#define $name$f\t${name}common_name_($f)\n";
	}

	for my $f (@{$api->{'order'}}) {
		do { print "\n"; next; } if ref $f ne '';
		my $s = $api->{'functions'}->{$f}->{'args'};
		my @args = @$s;
                my $r;
                unless ($noshift) {
                    shift @args;
                    my $astr = join ',', map { "a$_"; } (0..$#args);

                    $r= "#define $name$f($astr)\t${name}common_name_($f) ($name,$astr)\n";
                } else {
                    my $astr = join ',', map { "a$_"; } (0..$#args);

                    $r= "#define $name$f($astr)\t${name}common_name_($f) ($astr)\n";
                }
		$r =~ s/,\)/\)/;
		$r =~ s/,\)/\)/;

		print $r;
	}

        unless ($noshift) {
	print <<EOF;
/* customary link reference to the field -- forces good habit of defining
   it somewhere */
extern ${name}field $name;
EOF
}


	print <<EOF;
/* another customary shorthand */
#define	${name}degree	${name}field_degree()

EOF
	hfile_protect_end $h, "mpfq_name_$name";
}

# vim:set ft=perl:
